float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4	g_light;
float4	g_camera_eye_vector;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;
texture g_tex0;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
     Texture = (g_tex0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

struct OutputVS
{
	float4 posH		: POSITION;
	float2 UV		: TEXCOORD0;
	float3 Norm		: TEXCOORD1;
};

OutputVS SpecularVS( float4 posL : POSITION , float3 normal : NORMAL , float2 UV : TEXCOORD0 )
{
	OutputVS outVS = (OutputVS)0;

	outVS.posH = mul( posL , g_world_matrix );
	outVS.posH = mul( outVS.posH , g_view_projection_matrix );
	
	outVS.UV = UV;	

	outVS.Norm = mul( normal , g_world_matrix );

	return outVS;
}

float4 SpecularPS( float2 UV : TEXCOORD0, float3 Norm : TEXCOORD1 ) : COLOR
{
	float ndl = abs(dot(Norm, float3(-5, -5, 0)));
	float3 Diff = float3(1,1,1) * ndl;
	
	//return float4( Diff * tex2D( tex0, UV ).xyz, 1.0f);
	return tex2D( tex0, UV );
}

technique normal
{
	pass p0
	{
		vertexShader = compile vs_2_0 SpecularVS();
		pixelShader = compile ps_2_0 SpecularPS();
	}
}